%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This work by EPFL STI IBI LBNI is licensed under 
% a Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.
% Based on a work at http://lbni.epfl.ch/.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


function [gaussian_fit, gaussian_gof, n_peaks, position, height] = fit_multi_gauss(images,index,j,S,min_spacing_stdev_user,max_spacing_stdev_user,amplitude_fract,smoothing)
%UNTITLED Summary of this function goes here
%   Detailed explanation goes here
clear height position std_ini max_spacing_stdev min_spacing_stdev_ini min_peak_height min_peak_prime n_peaks t_hist_lower t_hist_upper t_hist_start t_hist gaussian_fit gaussian_gof

if ndims(images) >2
    im_list                                 = reshape(images(:,:,index),size(images(:,:,index),1)*size(images(:,:,index),2),1);
    im_list                                 = im_list(~isnan(im_list));
    [height position]                       = hist(im_list,str2double(get(S.histogram_bins, 'string')));                                                                 % Calculates the inital histogram
    std_ini                                 = std(im_list);                                                                                                                % Computes the inital standard deviation for improvement check
else
    im_list                                 = reshape(images(:,:),size(images(:,:),1)*size(images(:,:),2),1);
    im_list                                 = im_list(~isnan(im_list));
    [height position]                       = hist(im_list,str2double(get(S.histogram_bins, 'string')));                                                                 % Calculates the inital histogram
    std_ini                                 = std(im_list);                                                                                                                % Computes the inital standard deviation for improvement check
end

if get(S.Calc_flatten_lim(min([j,size(S.Calc_flatten_lim)])), 'value') == 1 
    max_spacing_stdev(index,j)              = 2.00*sqrt(2)*std_ini;
    min_spacing_stdev(index,j)              = 0.05*sqrt(2)*std_ini;
else
    if length(min_spacing_stdev_user) == 1
        min_spacing_stdev(index,j)              = sqrt(2)*min_spacing_stdev_user;
        max_spacing_stdev(index,j)              = sqrt(2)*max_spacing_stdev_user;
    else
        min_spacing_stdev(index,j)              = sqrt(2)*min_spacing_stdev_user(j);
        max_spacing_stdev(index,j)              = sqrt(2)*max_spacing_stdev_user(j);
    end
end
height                                      = smooth(height,smoothing,'loess');
height                                      = 100*height/sum(height);
position                                    = position';
min_peak_height                             = get(S.min_peak_height, 'string');
min_peak_height                             = str2double(min_peak_height{min([j,length(min_peak_height)]),1});
min_peak_height                             = min([min_peak_height,0.75*max(height)]);

%min_peak_height                             = min([str2double(get(S.min_peak_height(min([j,size(S.Calc_flatten_lim)])), 'string')),0.9*max(height)]);

if ceil(str2double(get(S.min_peak_distance(min([j,size(S.Calc_flatten_lim)])), 'string'))/mean(diff(position))) <= 1
    min_peak_prime                          = 2; 
elseif max([ceil(max_spacing_stdev(index,j)/mean(diff(position))),ceil(str2double(get(S.min_peak_distance(min([j,size(S.Calc_flatten_lim)])), 'string'))/mean(diff(position)))]) >= length(height) 
    min_peak_prime                          = length(height) -1;
else
    min_peak_prime                          = max([floor(max_spacing_stdev(index,j)/mean(diff(position))),floor(str2double(get(S.min_peak_distance(min([j,size(S.Calc_flatten_lim)])), 'string'))/mean(diff(position)))]);
end
[peak_height peak_index]                    = findpeaks(height,'MinPeakDistance', min_peak_prime,'MinPeakHeight', min_peak_height, 'Sortstr','descend');                                                                        % Finds peaks in the corrected image to identify different terrace
%n_peaks                                     = get(S.peaks_fit(min([j,size(S.Calc_flatten_lim)])), 'value');
n_peaks                                     = get(S.peaks_fit, 'value');
n_peaks                                     = n_peaks{min([j,length(n_peaks)])};

%disp(['Number of peaks to find: '   ,num2str(n_peaks)]);
%disp(['Number of peaks found: '     ,num2str(length(peak_height))]);

if length(peak_height) <= 8 && length(peak_height) >= n_peaks
        t_hist_lower                                = zeros(1,3*length(peak_height)); 
        t_hist_start                                = zeros(1,3*length(peak_height)); 
        t_hist_upper                                = zeros(1,3*length(peak_height));
        area_list                                   = zeros(1,length(peak_height)); 
        for iii                                     = 1:length(peak_height)                                                                                                   % Loops for the minimum of the number of peaks or 3
            t_hist_lower(3*(iii-1)+1)               = max([(1-amplitude_fract)*peak_height(iii),0.9*min_peak_height]);
            t_hist_lower(3*(iii-1)+2)               = position(peak_index(iii))-max([min_peak_prime,(min_spacing_stdev(index,j)+max_spacing_stdev(index,j))/2])/4;
            t_hist_lower(3*(iii-1)+3)               = min_spacing_stdev(index,j);

            t_hist_upper(3*(iii-1)+1)               = max([(1+amplitude_fract)*peak_height(iii),1.01*min_peak_height]);
            t_hist_upper(3*(iii-1)+2)               = position(peak_index(iii))+max([min_peak_prime,(min_spacing_stdev(index,j)+max_spacing_stdev(index,j))/2])/4;
            t_hist_upper(3*(iii-1)+3)               = max_spacing_stdev(index,j);

            t_hist_start(3*(iii-1)+1)               = max([(1-0)*peak_height(iii),0.99*min_peak_height]);
            t_hist_start(3*(iii-1)+2)               = position(peak_index(iii));
            t_hist_start(3*(iii-1)+3)               = (min_spacing_stdev(index,j)+max_spacing_stdev(index,j))/2;

        end
        t_hist                                      = fitoptions(   'Method','NonlinearLeastSquares',...                                                                                                                        % Sets the conditions for fitting
                                                                    'Lower',      t_hist_lower,...
                                                                    'Upper',      t_hist_upper,...
                                                                    'Startpoint', t_hist_start,...
                                                                    'MaxIter',    1e2,...
                                                                    'MaxFunEvals',3e2);
        func_form                                   = ['gauss',num2str(length(peak_height))];
        f_Number_hist                               = fittype(func_form);
        [gaussian_fit,gaussian_gof]                 = fit(position, height, f_Number_hist, t_hist);
        for iii = 1:length(peak_height)
            area_list(1,iii)                = sum(eval(['gaussian_fit.a',num2str(iii),'*exp(-(position-gaussian_fit.b',num2str(iii),').^2/((gaussian_fit.c',num2str(iii),')^2))']));
        end

    
        [area_sorted, ind_sorted]                   = sort(area_list,'descend');
        peak_height                                 = peak_height(sort(ind_sorted(1:n_peaks)));
        peak_index                                  = peak_index(sort(ind_sorted(1:n_peaks)));
        t_hist_lower                                = zeros(1,3*n_peaks); 
        t_hist_start                                = zeros(1,3*n_peaks); 
        t_hist_upper                                = zeros(1,3*n_peaks);
        for iii                                     = 1:n_peaks                                                                                                    % Loops for the minimum of the number of peaks or 3
            t_hist_lower(3*(iii-1)+1)               = max([(1-amplitude_fract)*peak_height(iii),0.9*min_peak_height])-1E-6;
            t_hist_lower(3*(iii-1)+2)               = position(peak_index(iii))-min([min_peak_prime,(min_spacing_stdev(index,j)+max_spacing_stdev(index,j))/2])/4-1E-6;
            t_hist_lower(3*(iii-1)+3)               = min_spacing_stdev(index,j)-1E-6;

            t_hist_upper(3*(iii-1)+1)               = max([(1+amplitude_fract)*peak_height(iii),1.01*min_peak_height])+1E-6;
            t_hist_upper(3*(iii-1)+2)               = position(peak_index(iii))+min([min_peak_prime,(min_spacing_stdev(index,j)+max_spacing_stdev(index,j))/2])/4+1E-6;
            t_hist_upper(3*(iii-1)+3)               = max_spacing_stdev(index,j)+1E-6;

            t_hist_start(3*(iii-1)+1)               = max([(1-0)*peak_height(iii),0.99*min_peak_height]);
            t_hist_start(3*(iii-1)+2)               = position(peak_index(iii));
            t_hist_start(3*(iii-1)+3)               = (min_spacing_stdev(index,j)+max_spacing_stdev(index,j))/2;

        end
        t_hist                                      = fitoptions(   'Method','NonlinearLeastSquares',...                                                                                                                        % Sets the conditions for fitting
                                                                    'Lower',      t_hist_lower,...
                                                                    'Upper',      t_hist_upper,...
                                                                    'Startpoint', t_hist_start,...
                                                                    'MaxIter',    1e2,...
                                                                    'MaxFunEvals',3e2);
        func_form                                   = ['gauss',num2str(n_peaks)];
        f_Number_hist                               = fittype(func_form);
        [gaussian_fit,gaussian_gof]                 = fit( position, height,f_Number_hist,t_hist);
        
else
    
    t_hist_lower                                    = zeros(1,3*min([get(S.peaks_fit(min([j,size(S.Calc_flatten_lim)])), 'value'),length(peak_height)]));
    t_hist_start                                    = zeros(1,3*min([get(S.peaks_fit(min([j,size(S.Calc_flatten_lim)])), 'value'),length(peak_height)])); 
    t_hist_upper                                    = zeros(1,3*min([get(S.peaks_fit(min([j,size(S.Calc_flatten_lim)])), 'value'),length(peak_height)])); 
    if ~isempty(peak_height) > 0
    n_peaks                                         = min([get(S.peaks_fit(min([j,size(S.Calc_flatten_lim)])), 'value'),length(peak_height)]);
    else
        n_peaks                                     = min([get(S.peaks_fit(min([j,size(S.Calc_flatten_lim)])), 'value')]);
    end
    for iii                                         = 1:n_peaks                                                                                                    % Loops for the minimum of the number of peaks or 3
        t_hist_lower(3*(iii-1)+1)                   = max([(1-amplitude_fract)*peak_height(iii),0.99*min_peak_height])-1E-6;
        t_hist_lower(3*(iii-1)+2)                   = position(peak_index(iii))-min([min_peak_prime,(min_spacing_stdev(index,j)+max_spacing_stdev(index,j))/2])/4-1E-6;
        t_hist_lower(3*(iii-1)+3)                   = min_spacing_stdev(index,j)-1E-6;

        t_hist_upper(3*(iii-1)+1)                   = max([(1+amplitude_fract)*peak_height(iii),1.01*min_peak_height])+1E-6;
        t_hist_upper(3*(iii-1)+2)                   = position(peak_index(iii))+min([min_peak_prime,(min_spacing_stdev(index,j)+max_spacing_stdev(index,j))/2])/4+1E-6;
        t_hist_upper(3*(iii-1)+3)                   = max_spacing_stdev(index,j)+1E-6;

        t_hist_start(3*(iii-1)+1)                   = max([(1-0)*peak_height(iii),0.99*min_peak_height]);
        t_hist_start(3*(iii-1)+2)                   = position(peak_index(iii));
        t_hist_start(3*(iii-1)+3)                   = (min_spacing_stdev(index,j)+max_spacing_stdev(index,j))/2;

    end
    t_hist                                          = fitoptions(   'Method','NonlinearLeastSquares',...                                                                                                                        % Sets the conditions for fitting
                                                                    'Lower',      t_hist_lower,...
                                                                    'Upper',      t_hist_upper,...
                                                                    'Startpoint', t_hist_start,...
                                                                    'MaxIter',    1e2,...
                                                                    'MaxFunEvals',3e2);
    func_form                                       = ['gauss',num2str(n_peaks)];
    f_Number_hist                                   = fittype(func_form);
    [gaussian_fit,gaussian_gof]                     = fit( position, height,f_Number_hist,t_hist);   
end
% disp('Fit')
% disp(gaussian_fit)
% disp('GOF param')
% disp(gaussian_gof)
end

